<?php

namespace App\Models\HR;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Holiday extends Model 
{

    protected $table = 'holidays';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function appointment()
    {
        return $this->belongsTo('App\Models\HR\Appointment', 'appointment_id');
    }

    public function approver()
    {
        return $this->belongsTo('App\Models\HR\Appointment', 'approver_id');
    }

}